function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)
/**
 * This module will take 2 view states from the message_drawer_view_conversation
 * module and generate a patch that can be given to the
 * message_drawer_view_conversation_renderer module to update the UI.
 *
 * This module should never modify either state. It's purely a read only
 * module.
 *
 * @module     core_message/message_drawer_view_conversation_patcher
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */}define("core_message/message_drawer_view_conversation_patcher",["jquery","core/user_date","core_message/message_drawer_view_conversation_constants"],(function($,UserDate,Constants){var sortMessagesByDay=function(messages,midnight){var messagesByDay=messages.reduce((function(carry,message){var timeCreated=message.timeCreated?message.timeCreated:midnight,dayTimestamp=UserDate.getUserMidnightForTimestamp(timeCreated,midnight);return carry.hasOwnProperty(dayTimestamp)?carry[dayTimestamp].push(message):carry[dayTimestamp]=[message],carry}),{});return Object.keys(messagesByDay).map((function(dayTimestamp){return{timestamp:dayTimestamp,messages:messagesByDay[dayTimestamp]}}))},diffArrays=function(a,b,matchFunction){b=b.slice();var missingFromB=[],matches=[];return a.forEach((function(current){for(var found=!1,index=0;index<b.length;index++){var next=b[index];if(matchFunction(current,next)){found=!0,matches.push({a:current,b:next});break}}found?b.splice(index,1):missingFromB.push(current)})),{missingFromA:b,missingFromB:missingFromB,matches:matches}},findPositionInArray=function(array,breakFunction){for(var i=0;i<array.length;i++){var candidate=array[i];if(breakFunction(candidate))return candidate}return null},isArrayEqual=function(a,b){a=a.slice(),b=b.slice(),a.sort(),b.sort();var aLength=a.length,bLength=b.length;return aLength<1&&bLength<1||aLength==bLength&&a.every((function(item,index){return item==b[index]}))},isObjectEqual=function isObjectEqual(a,b){var aKeys=Object.keys(a),bKeys=Object.keys(b);return aKeys.length==bKeys.length&&aKeys.every((function(key){var aVal=a[key],bVal=b[key],aType=_typeof(aVal),bType=_typeof(bVal);if(bType=null===aVal?"null":bType,(aType="object"===(aType=null===aVal?"null":aType)&&Array.isArray(aType)?"array":aType)!==(bType="object"===bType&&Array.isArray(bType)?"array":bType))return!1;switch(aType){case"object":return isObjectEqual(aVal,bVal);case"array":return isArrayEqual(aVal,bVal);default:return a[key]==b[key]}}))},isMessageEqual=function(a,b){return isObjectEqual({id:a.id,state:a.sendState,text:a.text,timeCreated:a.timeCreated},{id:b.id,state:b.sendState,text:b.text,timeCreated:b.timeCreated})},buildDaysPatch=function(current,remove,add){return{remove:remove,add:add.map((function(day){return{before:findPositionInArray(current,(function(candidate){return day.timestamp<candidate.timestamp})),value:day}}))}},buildConversationPatch=function(state,newState){var matchingDays,remove,add,update,diff=diffArrays(state.messages,newState.messages,isMessageEqual);if(diff.missingFromA.length||diff.missingFromB.length){var current=sortMessagesByDay(state.messages,state.midnight),next=sortMessagesByDay(newState.messages,newState.midnight),daysDiff=diffArrays(current,next,(function(dayCurrent,dayNext){return dayCurrent.timestamp==dayNext.timestamp}));return{days:buildDaysPatch(current,daysDiff.missingFromB,daysDiff.missingFromA),messages:(matchingDays=daysDiff.matches,remove=[],add=[],update=[],matchingDays.forEach((function(days){var dayCurrent=days.a,dayNext=days.b,messagesDiff=diffArrays(dayCurrent.messages,dayNext.messages,isMessageEqual),patch=diffArrays(messagesDiff.missingFromB,messagesDiff.missingFromA,(function(a,b){return a.id==b.id||a.sendState!=b.sendState&&a.timeAdded==b.timeAdded}));remove=remove.concat(patch.missingFromB),patch.missingFromA.forEach((function(message){var before=null;message.timeCreated&&(before=findPositionInArray(dayCurrent.messages,(function(candidate){return message.timeCreated==candidate.timeCreated?message.id<candidate.id:message.timeCreated<candidate.timeCreated}))),add.push({before:before,value:message,day:dayCurrent})})),update=update.concat(patch.matches.map((function(message){return{before:message.a,after:message.b}})))})),{add:add,remove:remove,update:update})}}return null},buildHeaderPatchTypePrivate=function(state,newState){var requireAddContact=buildRequireAddContact(state,newState),confirmContactRequest=buildConfirmContactRequest(state,newState),oldOtherUser=getOtherUserFromState(state),newOtherUser=getOtherUserFromState(newState),requiresAddContact=requireAddContact&&requireAddContact.show&&!requireAddContact.hasMessages,requiredAddContact=requireAddContact&&!requireAddContact.show,shouldRenderHeader=!oldOtherUser&&newOtherUser;return(shouldRenderHeader=(shouldRenderHeader=shouldRenderHeader||requiresAddContact||requiredAddContact)||null!==confirmContactRequest)?{type:Constants.CONVERSATION_TYPES.PRIVATE,showControls:!requiresAddContact&&!confirmContactRequest,context:{id:newState.id,name:newState.name,subname:newState.subname,totalmembercount:newState.totalMemberCount,imageurl:newState.imageUrl,isfavourite:newState.isFavourite,ismuted:newState.isMuted,showfavourite:null!==newState.id,userid:newOtherUser.id,showonlinestatus:newOtherUser.showonlinestatus,isonline:newOtherUser.isonline,isblocked:newOtherUser.isblocked,iscontact:newOtherUser.iscontact}}:null},buildHeaderPatchTypeSelf=function(state,newState){return null===state.name&&null!==newState.name?{type:Constants.CONVERSATION_TYPES.SELF,showControls:!1,context:{id:newState.id,name:newState.name,subname:newState.subname,imageurl:newState.imageUrl,isfavourite:newState.isFavourite,showfavourite:null!==newState.id,showonlinestatus:!0}}:null},buildHeaderPatchTypePublic=function(state,newState){return state.totalMemberCount!=newState.totalMemberCount?{type:Constants.CONVERSATION_TYPES.PUBLIC,showControls:!0,context:{id:newState.id,name:newState.name,subname:newState.subname,totalmembercount:newState.totalMemberCount,imageurl:newState.imageUrl,isfavourite:newState.isFavourite,ismuted:newState.isMuted,showfavourite:null!==newState.id}}:null},buildScrollToMessagePatch=function(state,newState){var oldMessages=state.messages,newMessages=newState.messages;if(newMessages.length<1)return null;if(oldMessages.length<1)return newMessages[newMessages.length-1].id;var previousNewest=oldMessages[state.messages.length-1],currentNewest=newMessages[newMessages.length-1],previousOldest=oldMessages[0],currentOldest=newMessages[0];return previousNewest.id!=currentNewest.id?currentNewest.id:previousOldest.id!=currentOldest.id?previousOldest.id:null},buildLoadingMembersPatch=function(state,newState){return!(state.loadingMembers||!newState.loadingMembers)||!(state.loadingMembers&&!newState.loadingMembers)&&null},buildLoadingFirstMessages=function(state,newState){return state.hasTriedToLoadMessages===newState.hasTriedToLoadMessages?null:!(newState.hasTriedToLoadMessages||!newState.loadingMessages)||!(newState.hasTriedToLoadMessages&&!newState.loadingMessages)&&null},buildLoadingMessages=function(state,newState){return!(state.loadingMessages||!newState.loadingMessages)||!(state.loadingMessages&&!newState.loadingMessages)&&null},buildShowEmojiPicker=function(state,newState){return!(state.showEmojiPicker||!newState.showEmojiPicker)||!(state.showEmojiPicker&&!newState.showEmojiPicker)&&null},buildShowEmojiAutoComplete=function(state,newState){return!(state.showEmojiAutoComplete||!newState.showEmojiAutoComplete)||!(state.showEmojiAutoComplete&&!newState.showEmojiAutoComplete)&&null},buildConfirmBlockUser=function(state,newState){if(newState.pendingBlockUserIds.length){var userId=newState.pendingBlockUserIds[0];return newState.members[userId]}return!state.pendingBlockUserIds.length&&null},buildConfirmUnblockUser=function(state,newState){if(newState.pendingUnblockUserIds.length){var userId=newState.pendingUnblockUserIds[0];return newState.members[userId]}return!state.pendingUnblockUserIds.length&&null},buildConfirmAddContact=function(state,newState){if(newState.pendingAddContactIds.length){var userId=newState.pendingAddContactIds[0];return newState.members[userId]}return!state.pendingAddContactIds.length&&null},buildConfirmRemoveContact=function(state,newState){if(newState.pendingRemoveContactIds.length){var userId=newState.pendingRemoveContactIds[0];return newState.members[userId]}return!state.pendingRemoveContactIds.length&&null},buildConfirmDeleteSelectedMessages=function(state,newState){var oldPendingCount=state.pendingDeleteMessageIds.length,newPendingCount=newState.pendingDeleteMessageIds.length;return newPendingCount&&!oldPendingCount?{show:!0,type:newState.type,canDeleteMessagesForAllUsers:newState.canDeleteMessagesForAllUsers}:oldPendingCount&&!newPendingCount?{show:!1}:null},buildConfirmDeleteConversation=function(state,newState){return!state.pendingDeleteConversation&&newState.pendingDeleteConversation?newState.type:!(state.pendingDeleteConversation&&!newState.pendingDeleteConversation)&&null},buildConfirmContactRequest=function(state,newState){var loggedInUserId=state.loggedInUserId,oldOtherUser=getOtherUserFromState(state),newOtherUser=getOtherUserFromState(newState),oldReceivedRequests=oldOtherUser?oldOtherUser.contactrequests.filter((function(request){return request.requesteduserid==loggedInUserId&&request.userid==oldOtherUser.id})):[],newReceivedRequests=newOtherUser?newOtherUser.contactrequests.filter((function(request){return request.requesteduserid==loggedInUserId&&request.userid==newOtherUser.id})):[],oldRequest=oldReceivedRequests.length?oldReceivedRequests[0]:null,newRequest=newReceivedRequests.length?newReceivedRequests[0]:null;return!oldRequest&&newRequest?newOtherUser:!(oldRequest&&!newRequest)&&null},buildIsBlocked=function(state,newState){var oldOtherUser=getOtherUserFromState(state),newOtherUser=getOtherUserFromState(newState);return oldOtherUser||newOtherUser?!oldOtherUser&&newOtherUser?!!newOtherUser.isblocked||null:!newOtherUser&&oldOtherUser?!oldOtherUser.isblocked&&null:!(oldOtherUser.isblocked&&!newOtherUser.isblocked)&&(!(oldOtherUser.isblocked||!newOtherUser.isblocked)||null):null},buildIsFavourite=function(state,newState){var oldIsFavourite=state.isFavourite,newIsFavourite=newState.isFavourite;return null===state.id&&null===newState.id?null:null===state.id&&null!==newState.id?"show-add":null!==state.id&&null===newState.id?"hide":oldIsFavourite==newIsFavourite?null:!oldIsFavourite&&newIsFavourite?"show-remove":oldIsFavourite&&!newIsFavourite?"show-add":null},buildIsMuted=function(state,newState){var oldIsMuted=state.isMuted,newIsMuted=newState.isMuted;return null===state.id&&null===newState.id?null:null===state.id&&null!==newState.id?"show-mute":null!==state.id&&null===newState.id?"hide":oldIsMuted==newIsMuted?null:!oldIsMuted&&newIsMuted?"show-unmute":oldIsMuted&&!newIsMuted?"show-mute":null},buildIsContact=function(state,newState){var loggedInUserId=state.loggedInUserId,oldOtherUser=getOtherUserFromState(state),newOtherUser=getOtherUserFromState(newState),oldContactRequests=oldOtherUser?oldOtherUser.contactrequests.filter((function(request){return request.userid==loggedInUserId&&request.requesteduserid==oldOtherUser.id||request.userid==oldOtherUser.id&&request.requesteduserid==loggedInUserId})):[],newContactRequests=newOtherUser?newOtherUser.contactrequests.filter((function(request){return request.userid==loggedInUserId&&request.requesteduserid==newOtherUser.id||request.userid==newOtherUser.id&&request.requesteduserid==loggedInUserId})):[],oldHasContactRequests=oldContactRequests.length>0,newHasContactRequests=newContactRequests.length>0;return oldOtherUser||newOtherUser?oldHasContactRequests&&newHasContactRequests?null:oldHasContactRequests||!newHasContactRequests||newOtherUser.iscontact?!oldOtherUser&&newOtherUser?newOtherUser.iscontact?"contact":null:!newOtherUser&&oldOtherUser?oldOtherUser.iscontact?"non-contact":null:oldOtherUser.iscontact&&!newOtherUser.iscontact?newHasContactRequests?"pending-contact":"non-contact":!oldOtherUser.iscontact&&newOtherUser.iscontact?"contact":null:"pending-contact":null},buildLoadingConfirmationAction=function(state,newState){return!(state.loadingConfirmAction||!newState.loadingConfirmAction)||!(state.loadingConfirmAction&&!newState.loadingConfirmAction)&&null},buildInEditMode=function(state,newState){var oldHasSelectedMessages=state.selectedMessageIds.length>0,newHasSelectedMessages=newState.selectedMessageIds.length>0,numberOfMessagesHasChanged=state.messages.length!=newState.messages.length;return!(oldHasSelectedMessages||!newHasSelectedMessages)||!(oldHasSelectedMessages&&!newHasSelectedMessages)&&(!(!oldHasSelectedMessages||!numberOfMessagesHasChanged)||null)},buildSelectedMessages=function(state,newState){var oldSelectedMessages=state.selectedMessageIds,newSelectedMessages=newState.selectedMessageIds;if(isArrayEqual(oldSelectedMessages,newSelectedMessages))return null;var diff=diffArrays(oldSelectedMessages,newSelectedMessages,(function(a,b){return a==b}));return{count:newSelectedMessages.length,add:diff.missingFromA,remove:diff.missingFromB}},getOtherUserFromState=function(state){return Object.keys(state.members).reduce((function(carry,userId){return userId==state.loggedInUserId||carry||(carry=state.members[userId]),carry}),null)},requiresContactRequest=function(loggedInUserId,user){if(user.canmessage)return!1;var hasSentContactRequest=user.contactrequests.filter((function(request){return request.userid==loggedInUserId||request.requesteduserid})).length>0;return user.requirescontact&&!user.iscontact&&!hasSentContactRequest},buildRequireAddContact=function(state,newState){var oldOtherUser=getOtherUserFromState(state),newOtherUser=getOtherUserFromState(newState),hadMessages=state.messages.length>0,hasMessages=newState.messages.length>0,loggedInUserId=newState.loggedInUserId,prevRequiresContactRequest=oldOtherUser&&requiresContactRequest(loggedInUserId,oldOtherUser),nextRequiresContactRequest=newOtherUser&&requiresContactRequest(loggedInUserId,newOtherUser),finishedAddContact=!1===buildConfirmAddContact(state,newState);if(!state.hasTriedToLoadMessages&&!newState.hasTriedToLoadMessages)return null;if(!oldOtherUser&&!newOtherUser)return null;if(!oldOtherUser&&nextRequiresContactRequest)return{show:!0,hasMessages:hasMessages,user:newOtherUser};if(finishedAddContact&&nextRequiresContactRequest)return{show:!0,hasMessages:hasMessages,user:newOtherUser};if(state.hasTriedToLoadMessages&&newState.hasTriedToLoadMessages){if(!prevRequiresContactRequest&&nextRequiresContactRequest)return{show:!0,hasMessages:hasMessages,user:newOtherUser};if(prevRequiresContactRequest&&!nextRequiresContactRequest)return{show:!1,hasMessages:hasMessages}}return!state.hasTriedToLoadMessages&&newState.hasTriedToLoadMessages&&nextRequiresContactRequest?{show:!0,hasMessages:hasMessages,user:newOtherUser}:state.hasTriedToLoadMessages&&!newState.hasTriedToLoadMessages&&prevRequiresContactRequest?{show:!1,hasMessages:hadMessages}:null},buildFooterPatchTypePrivate=function(state,newState){var loadingFirstMessages=buildLoadingFirstMessages(state,newState),inEditMode=buildInEditMode(state,newState),requireAddContact=buildRequireAddContact(state,newState),requireUnblock=function(state,newState){var oldOtherUser=getOtherUserFromState(state),newOtherUser=getOtherUserFromState(newState);return oldOtherUser||newOtherUser?oldOtherUser&&!newOtherUser?!oldOtherUser.isblocked&&null:!oldOtherUser&&newOtherUser?!!newOtherUser.isblocked||null:!(oldOtherUser.isblocked||!newOtherUser.isblocked)||!(oldOtherUser.isblocked&&!newOtherUser.isblocked)&&null:null}(state,newState),unableToMessage=function(state,newState){var oldOtherUser=getOtherUserFromState(state),newOtherUser=getOtherUserFromState(newState);return newState.type==Constants.CONVERSATION_TYPES.SELF?null:oldOtherUser||newOtherUser?oldOtherUser&&!newOtherUser?!oldOtherUser.canmessage||null:!oldOtherUser&&newOtherUser?!newOtherUser.canmessage||null:!(!oldOtherUser.canmessage&&newOtherUser.canmessage)&&(!(!oldOtherUser.canmessage||newOtherUser.canmessage)||null):null}(state,newState),showRequireAddContact=null!==requireAddContact?requireAddContact.show&&requireAddContact.hasMessages:null,otherUser=getOtherUserFromState(newState),generateReturnValue=function(checkValue,successReturn){if(checkValue)return successReturn;if(null!==checkValue&&!checkValue){if(!otherUser)return{type:"content"};if(otherUser.isblocked)return{type:"unblock"};if(newState.messages.length&&requiresContactRequest(newState.loggedInUserId,otherUser))return{type:"add-contact",user:otherUser};if(!otherUser.canmessage&&otherUser.requirescontact&&!otherUser.iscontact)return{type:"unable-to-message"}}return null};if(null===loadingFirstMessages&&null===inEditMode&&null===requireAddContact&&null===requireUnblock)return null;for(var checks=[[loadingFirstMessages,{type:"placeholder"}],[inEditMode,{type:"edit-mode"}],[unableToMessage,{type:"unable-to-message"}],[requireUnblock,{type:"unblock"}],[showRequireAddContact,{type:"add-contact",user:otherUser}]],i=0;i<checks.length;i++){var result=generateReturnValue(checks[i][0],checks[i][1]);if(null!==result)return result}return{type:"content"}},buildFooterPatchTypePublic=function(state,newState){var loadingFirstMessages=buildLoadingFirstMessages(state,newState),inEditMode=buildInEditMode(state,newState);return null===loadingFirstMessages&&null===inEditMode?null:loadingFirstMessages?{type:"placeholder"}:inEditMode?{type:"edit-mode"}:{type:"content"}},buildReset=function(state,newState){var oldType=state.type,newType=newState.type,oldConversationId=state.id,newConversationId=newState.id,oldMemberIds=Object.keys(state.members),newMemberIds=Object.keys(newState.members);oldMemberIds.sort(),newMemberIds.sort();var membersUnchanged=oldMemberIds.every((function(id,index){return id==newMemberIds[index]}));return oldType!=newType||(!(!oldConversationId||newConversationId)||(!(!oldConversationId||!newConversationId||oldConversationId==newConversationId)||(!(oldConversationId||newConversationId||membersUnchanged)||null)))},buildSelfConversationMessage=function(state,newState){return state.type!=newState.type?newState.type==Constants.CONVERSATION_TYPES.SELF:null},buildContactRequestSent=function(state,newState){var loggedInUserId=newState.loggedInUserId,oldOtherUser=getOtherUserFromState(state),newOtherUser=getOtherUserFromState(newState),oldSentRequests=oldOtherUser?oldOtherUser.contactrequests.filter((function(request){return request.userid==loggedInUserId})):[],newSentRequests=newOtherUser?newOtherUser.contactrequests.filter((function(request){return request.userid==loggedInUserId})):[],oldRequest=oldSentRequests.length>0,newRequest=newSentRequests.length>0,hadMessages=state.messages.length>0,hasMessages=state.messages.length>0;return oldRequest||!newRequest||newOtherUser.iscontact||hasMessages?!(oldOtherUser&&!oldOtherUser.iscontact&&newRequest&&newOtherUser.iscontact)&&(!(oldRequest&&!newRequest)&&(!(!hadMessages&&hasMessages)&&null)):newOtherUser.fullname};return{buildPatch:function(state,newState){var config={all:{reset:buildReset,conversation:buildConversationPatch,scrollToMessage:buildScrollToMessagePatch,loadingMembers:buildLoadingMembersPatch,loadingFirstMessages:buildLoadingFirstMessages,loadingMessages:buildLoadingMessages,confirmDeleteSelectedMessages:buildConfirmDeleteSelectedMessages,inEditMode:buildInEditMode,selectedMessages:buildSelectedMessages,isFavourite:buildIsFavourite,isMuted:buildIsMuted,showEmojiPicker:buildShowEmojiPicker,showEmojiAutoComplete:buildShowEmojiAutoComplete}};config[Constants.CONVERSATION_TYPES.PRIVATE]={header:buildHeaderPatchTypePrivate,footer:buildFooterPatchTypePrivate,confirmBlockUser:buildConfirmBlockUser,confirmUnblockUser:buildConfirmUnblockUser,confirmAddContact:buildConfirmAddContact,confirmRemoveContact:buildConfirmRemoveContact,confirmContactRequest:buildConfirmContactRequest,confirmDeleteConversation:buildConfirmDeleteConversation,isBlocked:buildIsBlocked,isContact:buildIsContact,loadingConfirmAction:buildLoadingConfirmationAction,requireAddContact:buildRequireAddContact,contactRequestSent:buildContactRequestSent},config[Constants.CONVERSATION_TYPES.PUBLIC]={header:buildHeaderPatchTypePublic,footer:buildFooterPatchTypePublic},config[Constants.CONVERSATION_TYPES.SELF]={header:buildHeaderPatchTypeSelf,footer:buildFooterPatchTypePublic,confirmDeleteConversation:buildConfirmDeleteConversation,selfConversationMessage:buildSelfConversationMessage};var patchConfig=$.extend({},config.all);return newState.type&&newState.type in config&&(patchConfig=$.extend(patchConfig,config[newState.type])),Object.keys(patchConfig).reduce((function(patch,key){var value=(0,patchConfig[key])(state,newState);return null!==value&&(patch[key]=value),patch}),{})}}}));

//# sourceMappingURL=message_drawer_view_conversation_patcher.min.js.map