/**
 * Aria menubar functionality. Enhances a simple nested list structure into a full aria widget.
 * Based on the open ajax example: http://oaa-accessibility.org/example/26/
 *
 * @module     tool_lp/menubar
 * @package    tool_lp
 * @copyright  2015 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_lp/menubar",["jquery"],(function($){var documentClickHandlerRegistered=!1,menuActive=!1,closeAllSubMenus=function(){$(".tool-lp-menu .tool-lp-sub-menu").attr("aria-hidden","true"),menuActive=!1},Menubar=function(menuRoot,handlers){this.menuRoot=menuRoot,this.handlers=handlers,this.rootMenus=this.menuRoot.children("li"),this.subMenus=this.rootMenus.children("ul"),this.subMenuItems=this.subMenus.children("li"),this.allItems=this.rootMenus.add(this.subMenuItems),this.activeItem=null,this.isChildOpen=!1,this.keys={tab:9,enter:13,esc:27,space:32,left:37,up:38,right:39,down:40},this.addAriaAttributes(),this.addEventListeners()};return Menubar.prototype.openSubMenu=function(menu){this.setOpenDirection(),closeAllSubMenus(),menu.attr("aria-hidden","false"),menuActive=!0},Menubar.prototype.addEventListeners=function(){var currentThis=this;!1===documentClickHandlerRegistered&&($(document).click((function(){menuActive&&closeAllSubMenus()})),documentClickHandlerRegistered=!0),this.subMenuItems.mouseenter((function(){return $(this).addClass("menu-hover"),!0})),this.subMenuItems.mouseout((function(){return $(this).removeClass("menu-hover"),!0})),this.allItems.click((function(e){return currentThis.handleClick($(this),e)})),this.allItems.keydown((function(e){return currentThis.handleKeyDown($(this),e)})),this.allItems.focus((function(){return currentThis.handleFocus($(this))})),this.allItems.blur((function(){return currentThis.handleBlur($(this))}))},Menubar.prototype.handleClick=function(item,e){if(e.stopPropagation(),item.parent().is(".tool-lp-menu"))"true"==item.children("ul").first().attr("aria-hidden")?this.openSubMenu(item.children("ul").first()):item.children("ul").first().attr("aria-hidden","true");else{this.allItems.removeClass("menu-hover menu-focus"),this.activeItem=null,this.menuRoot.find("ul").not(".root-level").attr("aria-hidden","true");var anchor=item.find("a").first(),clickEvent=new $.Event("click");clickEvent.target=anchor;var eventHandled=!1;this.handlers&&$.each(this.handlers,(function(selector,handler){if(!eventHandled&&item.find(selector).length>0){var callable=$.proxy(handler,anchor);eventHandled=!1===callable(clickEvent)||clickEvent.isDefaultPrevented()}})),eventHandled||"#"===anchor.attr("href")||(window.location.href=anchor.attr("href"))}return!1},Menubar.prototype.handleFocus=function(item){if(null===this.activeItem)this.activeItem=item;else if(item[0]!=this.activeItem[0])return!0;var parentItems=this.activeItem.parentsUntil("ul.tool-lp-menu").filter("li");(this.allItems.removeClass("menu-focus"),this.activeItem.addClass("menu-focus"),parentItems.addClass("menu-focus"),!0===this.isChildOpen)&&(item.parent().is(".tool-lp-menu")&&"true"==item.attr("aria-haspopup")&&this.openSubMenu(item.children("ul").first()));return!0},Menubar.prototype.handleBlur=function(item){return item.removeClass("menu-focus"),!0},Menubar.prototype.setOpenDirection=function(){var pos=this.menuRoot.offset(),isRTL=$(document.body).hasClass("dir-rtl"),heightmenuRoot=this.rootMenus.outerHeight(),widthmenuRoot=this.rootMenus.outerWidth(),subMenuContainer=this.rootMenus.find("ul.tool-lp-sub-menu");subMenuContainer.css("margin-right",""),subMenuContainer.css("margin-left",""),subMenuContainer.css("margin-top",""),subMenuContainer.attr("aria-hidden",!1);var menuRealWidth=subMenuContainer.outerWidth(),menuRealHeight=subMenuContainer.outerHeight(),margintop=null,marginright=null,marginleft=null;pos.top-$(window).scrollTop()+menuRealHeight>$(window).height()&&(margintop=menuRealHeight+heightmenuRoot,subMenuContainer.css("margin-top","-"+margintop+"px")),isRTL?pos.left-menuRealWidth<0&&(marginright=menuRealWidth-widthmenuRoot,subMenuContainer.css("margin-right","-"+marginright+"px")):pos.left+menuRealWidth>$(window).width()&&(marginleft=menuRealWidth-widthmenuRoot,subMenuContainer.css("margin-left","-"+marginleft+"px")),this.menuRoot.addClass("tool-lp-menu-open-left")},Menubar.prototype.handleKeyDown=function(item,e){if(e.altKey||e.ctrlKey)return!0;switch(e.keyCode){case this.keys.tab:this.menuRoot.find("ul").attr("aria-hidden","true"),this.allItems.removeClass("menu-focus"),this.activeItem=null,this.isChildOpen=!1;break;case this.keys.esc:var itemUL=item.parent();return itemUL.is(".tool-lp-menu")?item.children("ul").first().attr("aria-hidden","true"):(this.activeItem=itemUL.parent(),this.isChildOpen=!1,this.activeItem.focus(),itemUL.attr("aria-hidden","true")),e.stopPropagation(),!1;case this.keys.enter:case this.keys.space:return this.handleClick(item,e);case this.keys.left:return this.activeItem=this.moveToPrevious(item),this.activeItem.focus(),e.stopPropagation(),!1;case this.keys.right:return this.activeItem=this.moveToNext(item),this.activeItem.focus(),e.stopPropagation(),!1;case this.keys.up:return this.activeItem=this.moveUp(item),this.activeItem.focus(),e.stopPropagation(),!1;case this.keys.down:return this.activeItem=this.moveDown(item),this.activeItem.focus(),e.stopPropagation(),!1}return!0},Menubar.prototype.moveToNext=function(item){var itemUL=item.parent(),menuItems=itemUL.children("li"),menuNum=menuItems.length,menuIndex=menuItems.index(item),newItem=null,childMenu=null;if(itemUL.is(".tool-lp-menu"))newItem=menuIndex<menuNum-1?item.next():menuItems.first(),"true"==item.attr("aria-haspopup")&&"false"==(childMenu=item.children("ul").first()).attr("aria-hidden")&&(childMenu.attr("aria-hidden","true"),this.isChildOpen=!0),item.removeClass("menu-focus"),"true"===newItem.attr("aria-haspopup")&&!0===this.isChildOpen&&(childMenu=newItem.children("ul").first(),this.openSubMenu(childMenu));else if("true"==item.attr("aria-haspopup"))newItem=(childMenu=item.children("ul").first()).children("li").first(),this.openSubMenu(childMenu);else{var parentMenus=null,rootItem=null;(parentMenus=item.parentsUntil("ul.tool-lp-menu").filter("ul").not(".tool-lp-menu")).attr("aria-hidden","true"),parentMenus.find("li").removeClass("menu-focus"),parentMenus.last().parent().removeClass("menu-focus"),rootItem=parentMenus.last().parent(),(newItem=(menuIndex=this.rootMenus.index(rootItem))<this.rootMenus.length-1?rootItem.next():this.rootMenus.first()).addClass("menu-focus"),"true"==newItem.attr("aria-haspopup")&&(childMenu=newItem.children("ul").first(),newItem=childMenu.children("li").first(),this.openSubMenu(childMenu),this.isChildOpen=!0)}return newItem},Menubar.prototype.moveToPrevious=function(item){var itemUL=item.parent(),menuItems=itemUL.children("li"),menuIndex=menuItems.index(item),newItem=null,childMenu=null;if(itemUL.is(".tool-lp-menu"))newItem=menuIndex>0?item.prev():menuItems.last(),"true"==item.attr("aria-haspopup")&&"false"==(childMenu=item.children("ul").first()).attr("aria-hidden")&&(childMenu.attr("aria-hidden","true"),this.isChildOpen=!0),item.removeClass("menu-focus"),"true"===newItem.attr("aria-haspopup")&&!0===this.isChildOpen&&(childMenu=newItem.children("ul").first(),this.openSubMenu(childMenu));else{var parentLI=itemUL.parent();parentLI.parent().is(".tool-lp-menu")?(itemUL.attr("aria-hidden","true"),item.removeClass("menu-focus"),parentLI.removeClass("menu-focus"),(newItem=(menuIndex=this.rootMenus.index(parentLI))>0?parentLI.prev():this.rootMenus.last()).addClass("menu-focus"),"true"==newItem.attr("aria-haspopup")&&(childMenu=newItem.children("ul").first(),this.openSubMenu(childMenu),this.isChildOpen=!0,newItem=childMenu.children("li").first())):(newItem=itemUL.parent(),itemUL.attr("aria-hidden","true"),item.removeClass("menu-focus"))}return newItem},Menubar.prototype.moveDown=function(item,startChr){var itemUL=item.parent(),menuItems=itemUL.children("li").not(".separator"),menuNum=menuItems.length,menuIndex=menuItems.index(item),newItem=null,newItemUL=null;if(itemUL.is(".tool-lp-menu"))return"true"!=item.attr("aria-haspopup")?item:(newItem=(newItemUL=item.children("ul").first()).children("li").first(),this.openSubMenu(newItemUL),newItem);if(startChr){var match=!1,curNdx=menuIndex+1;for(curNdx==menuNum&&(curNdx=0);curNdx!=menuIndex;){if(menuItems.eq(curNdx).html().charAt(0).toLowerCase()==startChr){match=!0;break}(curNdx+=1)==menuNum&&(curNdx=0)}return!0===match?(newItem=menuItems.eq(curNdx),item.removeClass("menu-focus"),newItem):item}return newItem=menuIndex<menuNum-1?menuItems.eq(menuIndex+1):menuItems.first(),item.removeClass("menu-focus"),newItem},Menubar.prototype.moveUp=function(item){var itemUL=item.parent(),menuItems=itemUL.children("li").not(".separator"),menuIndex=menuItems.index(item),newItem=null;return itemUL.is(".tool-lp-menu")?item:(newItem=menuIndex>0?menuItems.eq(menuIndex-1):menuItems.last(),item.removeClass("menu-focus"),newItem)},Menubar.prototype.addAriaAttributes=function(){this.menuRoot.attr("role","menubar"),this.rootMenus.attr("role","menuitem"),this.rootMenus.attr("tabindex","0"),this.rootMenus.attr("aria-haspopup","true"),this.subMenus.attr("role","menu"),this.subMenus.attr("aria-hidden","true"),this.subMenuItems.attr("role","menuitem"),this.subMenuItems.attr("tabindex","-1"),this.menuRoot.addClass("tool-lp-menu"),this.allItems.addClass("tool-lp-menu-item"),this.rootMenus.addClass("tool-lp-root-menu"),this.subMenus.addClass("tool-lp-sub-menu"),this.subMenuItems.addClass("dropdown-item")},{enhance:function(selector,handler){$(selector).each((function(index,element){var menuRoot=$(element);!0!==menuRoot.data("menubarEnhanced")&&(new Menubar(menuRoot,handler),menuRoot.data("menubarEnhanced",!0))}))},closeAll:closeAllSubMenus}}));

//# sourceMappingURL=menubar.min.js.map