/**
 * This class manages the confirmation pop-up (also called the pre-flight check)
 * that is sometimes shown when a use clicks the start attempt button.
 *
 * This is also responsible for opening the pop-up window, if the quiz requires to be in one.
 *
 * @module    mod_quiz/preflightcheck
 * @class     preflightcheck
 * @package   mod_quiz
 * @copyright 2016 The Open University
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since     3.1
 */
define("mod_quiz/preflightcheck",["jquery","core/yui"],(function($,Y){var t={confirmDialogue:null,init:function(startButton,confirmationTitle,confirmationForm,popupoptions){var finalStartButton=startButton;Y.use("moodle-core-notification",(function(){Y.one(confirmationForm)&&(t.confirmDialogue=new M.core.dialogue({headerContent:confirmationTitle,bodyContent:Y.one(confirmationForm),draggable:!0,visible:!1,center:!0,modal:!0,width:null,extraClasses:["mod_quiz_preflight_popup"]}),Y.one(startButton).on("click",t.displayDialogue),Y.one("#id_cancel").on("click",t.hideDialogue),finalStartButton=t.confirmDialogue.get("boundingBox").one('[name="submitbutton"]')),popupoptions&&Y.one(finalStartButton).on("click",t.launchQuizPopup,t,popupoptions)}))},displayDialogue:function(e){e&&e.halt(),t.confirmDialogue.show()},hideDialogue:function(e){e&&e.halt(),t.confirmDialogue.hide(e)},launchQuizPopup:function(e,popupoptions){e.halt(),Y.use("moodle-core-formchangechecker","io-form",(function(){M.core_formchangechecker.reset_form_dirty_state();var form=e.target.ancestor("form");window.openpopup(e,{url:form.get("action")+"?"+Y.IO.stringify(form).replace(/\bcancel=/,"x="),windowname:"quizpopup",options:popupoptions,fullscreen:!0})}))}};return t}));

//# sourceMappingURL=preflightcheck.min.js.map