/**
 * Handle opening a dialogue to configure scale data.
 *
 * @module     tool_lp/scaleconfig
 * @package    tool_lp
 * @copyright  2015 Adrian Greeve <adrian@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_lp/scaleconfig",["jquery","core/notification","core/templates","core/ajax","tool_lp/dialogue","tool_lp/scalevalues"],(function($,notification,templates,ajax,Dialogue,ModScaleValues){var ScaleConfig=function(selectSelector,inputSelector,triggerSelector){this.selectSelector=selectSelector,this.inputSelector=inputSelector,this.triggerSelector=triggerSelector,this.originalscaleid=$(selectSelector).val(),$(selectSelector).on("change",this.scaleChangeHandler.bind(this)).change(),$(triggerSelector).click(this.showConfig.bind(this))};return ScaleConfig.prototype.selectSelector=null,ScaleConfig.prototype.inputSelector=null,ScaleConfig.prototype.triggerSelector=null,ScaleConfig.prototype.scalevalues=null,ScaleConfig.prototype.originalscaleid=0,ScaleConfig.prototype.scaleid=0,ScaleConfig.prototype.popup=null,ScaleConfig.prototype.showConfig=function(){var self=this;if(this.scaleid=$(this.selectSelector).val(),!(this.scaleid<=0)){var scalename=$(this.selectSelector).find("option:selected").text();this.getScaleValues(this.scaleid).done((function(){var context={scalename:scalename,scales:self.scalevalues};templates.render("tool_lp/scale_configuration_page",context).done((function(html){new Dialogue(scalename,html,self.initScaleConfig.bind(self))})).fail(notification.exception)})).fail(notification.exception)}},ScaleConfig.prototype.retrieveOriginalScaleConfig=function(){var jsonstring=$(this.inputSelector).val();if(""!==jsonstring){var scaleconfiguration=$.parseJSON(jsonstring);if(scaleconfiguration.shift().scaleid===this.originalscaleid)return scaleconfiguration}return""},ScaleConfig.prototype.initScaleConfig=function(popup){this.popup=popup;var body=$(popup.getContent());if(this.originalscaleid===this.scaleid){var currentconfig=this.retrieveOriginalScaleConfig();""!==currentconfig&&currentconfig.forEach((function(value){1===value.scaledefault&&body.find('[data-field="tool_lp_scale_default_'+value.id+'"]').attr("checked",!0),1===value.proficient&&body.find('[data-field="tool_lp_scale_proficient_'+value.id+'"]').attr("checked",!0)}))}body.on("click",'[data-action="close"]',function(){this.setScaleConfig(),popup.close()}.bind(this)),body.on("click",'[data-action="cancel"]',(function(){popup.close()}))},ScaleConfig.prototype.setScaleConfig=function(){var body=$(this.popup.getContent()),data=[{scaleid:this.scaleid}];this.scalevalues.forEach((function(value){var scaledefault=0,proficient=0;body.find('[data-field="tool_lp_scale_default_'+value.id+'"]').is(":checked")&&(scaledefault=1),body.find('[data-field="tool_lp_scale_proficient_'+value.id+'"]').is(":checked")&&(proficient=1),(scaledefault||proficient)&&data.push({id:value.id,scaledefault:scaledefault,proficient:proficient})}));var datastring=JSON.stringify(data);$(this.inputSelector).val(datastring),this.originalscaleid=this.scaleid},ScaleConfig.prototype.getScaleValues=function(scaleid){return ModScaleValues.get_values(scaleid).then(function(values){return this.scalevalues=values,values}.bind(this))},ScaleConfig.prototype.scaleChangeHandler=function(e){$(e.target).val()<=0?$(this.triggerSelector).prop("disabled",!0):$(this.triggerSelector).prop("disabled",!1)},{init:function(selectSelector,inputSelector,triggerSelector){return new ScaleConfig(selectSelector,inputSelector,triggerSelector)}}}));

//# sourceMappingURL=scaleconfig.min.js.map