/**
 * Show/hide admin settings based on other settings selected
 *
 * @package core
 * @copyright 2018 Davo Smith, Synergy Learning
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/showhidesettings",["jquery"],(function($){var dependencies;function isCheckboxHiddenElement($el){return $el.is("input[type=hidden]")&&$el.siblings('input[type=checkbox][name="'+$el.attr("name")+'"]').length}function isCheckedRelevant($el,value){return!isCheckboxHiddenElement($el)&&!function($el,value){return $el.is("input[type=radio]")&&$el.attr("value")!==value}($el,value)}function isUncheckedRadioButton($el){return $el.is("input[type=radio]")&&!$el.prop("checked")}function isUncheckedCheckbox($el){return $el.is("input[type=checkbox]")&&!$el.prop("checked")}function isMultiSelect($el){return $el.is("select")&&$el.prop("multiple")}function multiSelectMatches($el,values){var selected=$el.val()||[];if(!values.length)return!1;if(selected.length!==values.length)return!1;for(var i in selected)if(selected.hasOwnProperty(i)&&-1===values.indexOf(selected[i]))return!1;return!0}var depFns={notchecked:function($dependon,value){var hide=!1;return value=String(value),$dependon.each((function(idx,el){var $el=$(el);isCheckedRelevant($el,value)&&(hide=hide||!$el.prop("checked"))})),hide},checked:function($dependon,value){var hide=!1;return value=String(value),$dependon.each((function(idx,el){var $el=$(el);isCheckedRelevant($el,value)&&(hide=hide||$el.prop("checked"))})),hide},noitemselected:function($dependon){var hide=!1;return $dependon.each((function(idx,el){var $el=$(el);hide=hide||-1===$el.prop("selectedIndex")})),hide},eq:function($dependon,value){var hide=!1,hiddenVal=!1;return value=String(value),$dependon.each((function(idx,el){var $el=$(el);if(!isUncheckedRadioButton($el))if(isCheckboxHiddenElement($el))hiddenVal=$el.val()===value;else if(isUncheckedCheckbox($el))hide=hide||hiddenVal;else if(isMultiSelect($el)){var values=value.split("|");hide=multiSelectMatches($el,values)}else hide=hide||$el.val()===value})),hide},in:function($dependon,value){var hide=!1,hiddenVal=!1,values=value.split("|");return $dependon.each((function(idx,el){var $el=$(el);isUncheckedRadioButton($el)||(isCheckboxHiddenElement($el)?hiddenVal=values.indexOf($el.val())>-1:hide=isUncheckedCheckbox($el)?hide||hiddenVal:isMultiSelect($el)?multiSelectMatches($el,values):hide||values.indexOf($el.val())>-1)})),hide},defaultCondition:function($dependon,value){var hide=!1,hiddenVal=!1;return value=String(value),$dependon.each((function(idx,el){var $el=$(el);if(!isUncheckedRadioButton($el))if(isCheckboxHiddenElement($el))hiddenVal=$el.val()!==value;else if(isUncheckedCheckbox($el))hide=hide||hiddenVal;else if(isMultiSelect($el)){var values=value.split("|");hide=!multiSelectMatches($el,values)}else hide=hide||$el.val()!==value})),hide}};function getElementsByName(name){return $('[name="'+name+'"],[name^="'+name+'["]')}function updateDependencies(){var toHide={};$.each(dependencies,(function(dependonname){var dependon=getElementsByName(dependonname);$.each(dependencies[dependonname],(function(condition,values){$.each(values,(function(value,elements){var hide=function($dependon,condition,value){return"function"==typeof depFns[condition]?depFns[condition]($dependon,value):depFns.defaultCondition($dependon,value)}(dependon,condition,value);$.each(elements,(function(idx,elToHide){toHide.hasOwnProperty(elToHide)?toHide[elToHide]=toHide[elToHide]||hide:toHide[elToHide]=hide}))}))}))})),$.each(toHide,(function(elToHide,hide){getElementsByName(elToHide).each((function(idx,el){var $parent=$(el).closest(".form-item");$parent.length&&(hide?$parent.hide():$parent.show())}))}))}return{init:function(opts){dependencies=opts.dependencies,$.each(dependencies,(function(depname){var $el=getElementsByName(depname);$el.length&&$el.on("change",updateDependencies)})),updateDependencies(),$(".form-dependenton").hide()}}}));

//# sourceMappingURL=showhidesettings.min.js.map