/**
 * Controls the preferences for the list of notification types on the
 * message preference page
 *
 * @module     core_message/preferences_notifications_list_controller
 * @class      preferences_notifications_list_controller
 * @package    message
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/preferences_notifications_list_controller",["jquery","core/ajax","core/notification","core/custom_interaction_events","core_message/notification_preference","core_message/notification_processor_settings","core/modal_factory"],(function($,Ajax,Notification,CustomEvents,NotificationPreference,NotificationProcessorSettings,ModalFactory){var SELECTORS_DISABLE_NOTIFICATIONS='[data-region="disable-notification-container"] [data-disable-notifications]',SELECTORS_DISABLE_NOTIFICATIONS_CONTAINER='[data-region="disable-notification-container"]',SELECTORS_PREFERENCE="[data-state]",SELECTORS_PREFERENCE_ROW='[data-region="preference-row"]',SELECTORS_PREFERENCE_INPUT="[data-state] input",SELECTORS_PROCESSOR_SETTING="[data-processor-setting]",PreferencesController=function(element){this.root=$(element),this.userId=this.root.attr("data-user-id"),this.registerEventListeners()};return PreferencesController.prototype.isDisabled=function(){return this.root.hasClass("disabled")},PreferencesController.prototype.setDisabled=function(){this.root.addClass("disabled"),this.root.find(SELECTORS_PREFERENCE_INPUT).prop("disabled",!0)},PreferencesController.prototype.setEnabled=function(){this.root.removeClass("disabled"),this.root.find(SELECTORS_PREFERENCE_INPUT).prop("disabled",!1)},PreferencesController.prototype.toggleDisableAllStatus=function(){var checkbox=$(SELECTORS_DISABLE_NOTIFICATIONS),container=$(SELECTORS_DISABLE_NOTIFICATIONS_CONTAINER),ischecked=checkbox.prop("checked");if(container.hasClass("loading"))return $.Deferred().resolve();container.addClass("loading");var request={methodname:"core_user_update_user_preferences",args:{userid:this.userId,emailstop:ischecked?1:0}};return Ajax.call([request])[0].done(function(){ischecked?this.setDisabled():this.setEnabled()}.bind(this)).always((function(){container.removeClass("loading")})).fail(Notification.exception)},PreferencesController.prototype.registerEventListeners=function(){var disabledNotificationsElement=$(SELECTORS_DISABLE_NOTIFICATIONS);CustomEvents.define(this.root,[CustomEvents.events.activate]),this.root.on("change",function(e){if(!this.isDisabled()){var preferenceElement=$(e.target).closest(SELECTORS_PREFERENCE),preferenceRow=$(e.target).closest(SELECTORS_PREFERENCE_ROW),preference=new NotificationPreference(preferenceRow,this.userId);preferenceElement.addClass("loading"),preference.save().always((function(){preferenceElement.removeClass("loading")}))}}.bind(this));var eventFormPromise=ModalFactory.create({type:NotificationProcessorSettings.TYPE});this.root.on(CustomEvents.events.activate,SELECTORS_PROCESSOR_SETTING,(function(e){var element=$(e.target).closest(SELECTORS_PROCESSOR_SETTING);e.preventDefault(),eventFormPromise.then((function(modal){modal.setUserId($(element).attr("data-user-id")),modal.setName($(element).attr("data-name")),modal.setContextId($(element).attr("data-context-id")),modal.setElement(element),modal.show(),e.stopImmediatePropagation()})).fail(Notification.exception)})),CustomEvents.define(disabledNotificationsElement,[CustomEvents.events.activate]),disabledNotificationsElement.on(CustomEvents.events.activate,function(){this.toggleDisableAllStatus()}.bind(this))},PreferencesController}));

//# sourceMappingURL=preferences_notifications_list_controller.min.js.map